<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('discount_package_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('discount_package_id')->constrained('discount_packages')->cascadeOnDelete()->cascadeOnUpdate();
            $table->morphs('items');
            $table->double('estimate_price');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('discount_package_items');
    }
};
