import { useAppearance } from '@/hooks/use-appearance';
import { cn } from '@/lib/utils';

const fonts = [
    { value: 'font-sans', label: 'Winky Sans' },
    { value: 'font-inter', label: 'Inter' },
    { value: 'font-poppins', label: 'Poppins' },
    { value: 'font-roboto', label: 'Roboto' },
    { value: 'font-figtree', label: 'Figtree' },
] as const;

export default function FontFamilyTabs() {
    const { fontFamily, updateFontFamily } = useAppearance();

    return (
        <div>
            <p className="mb-2 text-sm font-medium text-muted-foreground">
                Font Family
                </p>
            <div className="inline-flex gap-1 rounded-lg border border-border bg-card p-1 shadow-sm transition-colors">
                {fonts.map(({ value, label }) => (
                    <button
                        key={value}
                        onClick={() => updateFontFamily(value)}
                        className={cn(
                            'rounded-md px-3.5 py-1.5 text-sm font-medium transition-colors',
                            fontFamily === value
                                ? 'bg-accent text-accent-foreground shadow-sm'
                                : 'text-muted-foreground hover:bg-muted hover:text-foreground'
                        )}
                    >
                        {label}
                    </button>
                ))}
            </div>
        </div>
    );
}
