import Heading from '@/components/heading'
import { Button } from '@/components/ui/button'
import { Separator } from '@/components/ui/separator'
import { cn } from '@/lib/utils'
import { type NavItem } from '@/types'
import { Link } from '@inertiajs/react'
import { type PropsWithChildren } from 'react'

const sidebarNavItems: NavItem[] = [
  { title: 'Profile', href: '/settings/profile', icon: null },
  { title: 'Password', href: '/settings/password', icon: null },
  { title: 'Appearance', href: '/settings/appearance', icon: null },
]

export default function SettingsLayout({ children }: PropsWithChildren) {
  if (typeof window === 'undefined') return null

  const currentPath = window.location.pathname

  return (
    <div className="p-4 bg-background text-foreground transition-colors">
      <Heading title="Settings" description="Kelola profil dan pengaturan akun Anda" />

      <div className="mt-6 flex flex-col space-y-8 lg:flex-row lg:space-y-0 lg:space-x-12">
        {/* Sidebar Navigation */}
        <aside className="w-full max-w-xl lg:w-56 border border-border rounded-xl bg-card text-card-foreground p-3 shadow-sm">
          <nav className="flex flex-col space-y-1">
            {sidebarNavItems.map((item, index) => (
              <Button
                key={`${item.href}-${index}`}
                size="sm"
                variant="ghost"
                asChild
                className={cn(
                  'w-full justify-start rounded-lg transition-colors hover:bg-accent hover:text-accent-foreground',
                  currentPath === item.href && 'bg-accent text-accent-foreground font-semibold'
                )}
              >
                <Link href={item.href} prefetch>
                  {item.title}
                </Link>
              </Button>
            ))}
          </nav>
        </aside>

        {/* Separator (mobile only) */}
        <Separator className="my-6 border-border md:hidden" />

        {/* Content Area */}
        <div className="flex-1 md:max-w-full">
          <section className="w-full space-y-12 bg-card text-card-foreground border border-border rounded-xl p-4 shadow-sm transition-colors">
            {children}
          </section>
        </div>
      </div>
    </div>
  )
}
